% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_config.R
\name{set_config}
\alias{set_config}
\title{Modify the simulation configuration}
\usage{
set_config(
  sim,
  num_sim = 1000,
  parallel = FALSE,
  n_cores = NA,
  packages = NULL,
  stop_at_error = FALSE,
  progress_bar = TRUE,
  seed = as.integer(1e+09 * runif(1)),
  batch_levels = NA,
  return_batch_id = FALSE
)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{num_sim}{An integer; the number of simulations to conduct for each
level combination}

\item{parallel}{Boolean; if set to TRUE, \pkg{SimEngine} will run one
simulation per core. if set to FALSE, code will not be parallelized. See
the \href{https://avi-kenny.github.io/SimEngine/articles/parallelization.html}{Parallelization}
vignette for an overview of how parallelization works in \pkg{SimEngine}.}

\item{n_cores}{An integer; determines the number of cores on which the
simulation will run if using parallelization. Defaults to one fewer than
the number of available cores.}

\item{packages}{A character vector of packages to load and attach}

\item{stop_at_error}{Boolean; if set to TRUE, the simulation will stop if it
encounters an error in any single replicate Useful for debugging.}

\item{progress_bar}{Boolean; if set to FALSE, the progress bar that is
normally displayed while the simulation is running is suppressed.}

\item{seed}{An integer; seeds allow for reproducible simulation results. If a
seed is specified, then consecutive runs of the same simulation with the
same seed will lead to identical results (under normal circumstances). If
a seed was not set in advance by the user, \pkg{SimEngine} will set a
random seed, which can later be retrieved using the \code{\link{vars}}
function. See details for further info.}

\item{batch_levels}{Either NULL or a character vector. If the
\code{\link{batch}} function is being used within the simulation script,
this should contain the names of the simulation levels that are used
within the \code{\link{batch}} function code block. If no simulation
levels are used within the \code{\link{batch}} function code block,
specify NULL. See the documentation for the \code{\link{batch}} function.}

\item{return_batch_id}{Boolean. If set to TRUE, the batch_id will be included
as part of the simulation results}
}
\value{
The original simulation object with a modified configuration
}
\description{
This function sets configuration options for the simulation. If
    the 'packages' argument is specified, all packages will be loaded and
    attached via \code{library} when \code{set_config} is called. Multiple
    calls to \code{set_config} will only overwrite configuration options that
    are specified in the subsequent calls, leaving others in place. You can
    see the current configuration via \code{print(sim)}, where \code{sim} is
    your simulation object.
}
\details{
\itemize{
  \item{If a user specifies, for example, \code{set_config(seed=4)}, this
  seed is used twice by \pkg{SimEngine}. First, \pkg{SimEngine} executes
  \code{set.seed(4)} at the end of the \code{set_config} call. Second, this
  seed is used to generate a new set of seeds, one for each simulation
  replicate. Each of these seeds is set in turn (or in parallel) when
  \code{\link{run}} is called.}
  \item{Even if seeds are used, not all code will be reproducible. For
  example, a simulation that involves getting the current date/time with
  \code{Sys.time} or dynamically retrieving external data may produce
  different results on different runs.}
}
}
\examples{
sim <- new_sim()
sim \%<>\% set_config(
  num_sim = 10,
  seed = 2112
)
print(sim)
}
