% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{plot_clones}
\alias{plot_clones}
\title{Plot cluster/clone information}
\usage{
plot_clones(
  cnv_data,
  md,
  k,
  type,
  chrom_colors,
  text_size,
  title_size,
  legend_size_pt,
  legend_height_bar,
  hc_function = "ward.D2",
  plot_directory,
  spatial = TRUE
)
}
\arguments{
\item{cnv_data}{list object of cnv data from SlideCNA::prep_cnv_dat()}

\item{md}{data.table of metadata of each bead}

\item{k}{integer of number of clusters/clones}

\item{type}{character string, being "all" if using all binned beads, or "malig" if just malignant binned beads}

\item{chrom_colors}{vector of colors labeled by which chromosome they correspond to}

\item{text_size}{Ggplot2 text size}

\item{title_size}{Ggplot2 title size}

\item{legend_size_pt}{Ggplot2 legend_size_pt}

\item{legend_height_bar}{Ggplot2 legend_height_bar}

\item{hc_function}{character string for which hierarchical clustering function to use}

\item{plot_directory}{output plot directory path}

\item{spatial}{TRUE if using spatial information}
}
\value{
A hierarchical clustering object of the clusters
}
\description{
This function plots cluster dendrograms, spatial assignment, and the CNV heat map
}
