% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_slide_cna}
\alias{run_slide_cna}
\title{Run SlideCNA workflow}
\usage{
run_slide_cna(
  counts,
  beads_df,
  gene_pos,
  output_directory,
  plot_directory,
  spatial = TRUE,
  roll_mean_window = 101,
  avg_bead_per_bin = 12,
  pos = TRUE,
  pos_k = 55,
  ex_k = 1,
  hc_function_bin = "ward.D2",
  spatial_vars_to_plot = c("seurat_clusters", "bin_all", "N_bin", "umi_bin",
    "cluster_type"),
  scale_bin_thresh_hard = TRUE,
  lower_bound_cnv = 0.6,
  upper_bound_cnv = 1.4,
  hc_function_cnv = "ward.D2",
  hc_function_cnv_heatmap = "ward.D2",
  quantile_plot_cluster_label = "seurat_clusters",
  hc_function_silhouette = "ward.D2",
  max_k_silhouette = 10,
  plot_silhouette = TRUE,
  hc_function_plot_clones = "ward.D2",
  use_GO_terms = TRUE,
  chrom_ord = c("chr1", "chr2", "chr3", "chr4", "chr5", "chr6", "chr7", "chr8", "chr9",
    "chr10", "chr11", "chr12", "chr13", "chr14", "chr15", "chr16", "chr17", "chr18",
    "chr19", "chr20", "chr21", "chr22", "chr23", "chrX", "chrY", "chrM"),
  chrom_colors = c(chr1 = "#8DD3C7", chr2 = "#FFFFB3", chr3 = "#BEBADA", chr4 =
    "#FB8072", chr5 = "#80B1D3", chr6 = "#FDB462", chr7 = "#B3DE69", chr8 = "#FCCDE5",
    chr9 = "#D9D9D9", chr10 = "#BC80BD", chr11 = "#CCEBC5", chr12 = "#FFED6F", chr13 =
    "#1B9E77", chr14 = "#D95F02", chr15 = "#7570B3", chr16 = "#E7298A", chr17 =
    "#66A61E", chr18 = "#E6AB02", chr19 = "#A6761D", chr20 = "#666666", chr21 =
    "#A6CEE3", chr22 = "#1F78B4", chrX = "#B2DF8A"),
  text_size = 16,
  title_size = 18,
  legend_size_pt = 4,
  legend_height_bar = 1.5
)
}
\arguments{
\item{counts}{data.frame of raw counts (genes x beads)}

\item{beads_df}{data.frame of annotation of each bead (beads x annotations); contains columns 'bc' for bead names, 'cluster_type' for annotations of 'Normal' or 'Malignant', 'pos_x' for x-coordinate bead positions, and 'pos_y' for y-coordinate bead positions}

\item{gene_pos}{data.frame with columns for GENE, chr, start, end, rel_gene_pos (1 : # of genes on chromosome)}

\item{output_directory}{output directory path}

\item{plot_directory}{output plot directory path}

\item{spatial}{TRUE if using spatial information FALSE if not}

\item{roll_mean_window}{integer number of adjacent genes for which to average over in pyramidal weighting scheme}

\item{avg_bead_per_bin}{integer of average number of beads there should be per bin}

\item{pos}{TRUE if doing spatial and expressional binning, FALSE if just expressional binning}

\item{pos_k}{positional weight}

\item{ex_k}{expressional weight}

\item{hc_function_bin}{hierarchical clustering function for binning; to feed hclust's method argument, one of "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid"}

\item{spatial_vars_to_plot}{character vector of features to plot/columns of metadata}

\item{scale_bin_thresh_hard}{TRUE if using strict thresholds for expression thresholds and FALSE if adjusting
thresholds based on 1 + or - the mean of absolute min and max vlaues}

\item{lower_bound_cnv}{numeric float to represent the lower cap for CNV scores}

\item{upper_bound_cnv}{numeric float to represent the upper cap for CNV scores}

\item{hc_function_cnv}{character for which hierarchical clustering function to use for CNV-calling; to feed hclust's method argument, one of "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid"}

\item{hc_function_cnv_heatmap}{character for which hierarchical clustering function to use for visualzing CNV heat map; to feed hclust's method argument, one of "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid"}

\item{quantile_plot_cluster_label}{character string of which column name to keep in quantile plot}

\item{hc_function_silhouette}{character string for which hierarchical clustering function to use for
the Silhouette method; to feed hclust's method argument, one of "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid"}

\item{max_k_silhouette}{integer of number max number of clusters to evaluate (2:max_k_silhouette)
.       in Silhouette method}

\item{plot_silhouette}{TRUE if plotting silhouette scores for clustering}

\item{hc_function_plot_clones}{character string for which hierarchical clustering function to use
in plotting clones}

\item{use_GO_terms}{TRUE if using enrichR to get Gene Ontology terms for SlideCNA-defined clusters}

\item{chrom_ord}{character vector of order and names of chromosomes}

\item{chrom_colors}{character vector of which colors each chromosome should be in heat map}

\item{text_size}{integer of size of text in some ggplots}

\item{title_size}{integer of size of title in some ggplots}

\item{legend_size_pt}{integer of size of legend text size in some ggplots}

\item{legend_height_bar}{integer of height of legend bar in some ggplots}
}
\value{
None
}
\description{
Take a raw expression counts, cell type annotations, and positional cooridnates to identify CNA patterns across space and CNA-based clustering patterns
}
