% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{N_Boric}
\alias{N_Boric}
\title{Total, or Mineralizable Nitrogen using boric acid for ammonia absorption}
\usage{
N_Boric(W = W, VS = VS, VB = VB, X = X)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{VS}{Volume of standard sulphuric acid solution (mL) consumed in titration with soil}

\item{VB}{Volume of standard sulphuric acid solution (mL) consumed in titration without soil (i.e., blank titration)}

\item{X}{Normality of standard sulphuric acid solution}
}
\value{
N_pc - Nitrogen in soil (\%)
N_gkg - Nitrogen in soil (g/kg)
N_mgkg - Nitrogen in soil (mg/kg)
N_kgha - Nitrogen in soil (kg/ha)
}
\description{
Nitrogen in soil when the ammonia is absorbed in 4\% or 2\% boric acid (pH 4.5); and standard sulphuric acid is used for titration
}
\details{
In a soil, total N can be determined by first digesting the soil with concentrated sulphuric acid in presence of a digestion mixture containing potassium sulphate, cupric sulphate, and selenium powder in the ratio 200: 20: 1 at 390±5 °C till a clear solution (greenish coloured) is obtained. Then the acid digest is distilled with alkali (generally 40\% NaOH) to liberate ammonia gas which is then absorbed in 4\% boric acid solution, pH 4.5, and titrated against standard sulphuric acid solution to know the volume of the boric acid consumed during ammonia absorption (Bremner, 1996; Biswas, 2018). For available or mineralizable N, soil is distilled with alkaline potassium permanganate solution (0.32\%). The potassium permanganate oxidizes a part of soil organic matter, and liberates ammonia gas in the presence of an alkali, e.g., 40\% NaOH. The evolved ammonia is absorbed in 2\% boric acid solution containing mixed indicator, pH 4.5, and titrated against standard sulphuric acid solution to know the volume of the boric acid consumed during ammonia absorption (Subbiah and Asija, 1956; Biswas, 2018).
}
\examples{
with(data = df_N_Boric, N_Boric(W = Mass_Soil, VS = Vol_Sulphuric_Soil,
VB = Vol_Sulphuric_Blank, X = Normality_Sulphuric))

}
\references{
Biswas, D.R. (2018) Determination of different forms of nitrogen in soil and total N in plant. In Manual on Advanced Techniques for Analysis of Nutrients and Pollutant Elements in Soil, Plant and Human (S.P. Datta, M.C. Meena, B.S. Dwivedi, A.K. Shukla (Eds.), Westville Publishing House, New Delhi, pp. 57-68.

Bremner, J.M. (1996) Nitrogen Total. In Methods of Soil Analysis Part 3: Chemical Methods (D.L. Sparks (Eds.), SSSA Book Series 5, Soil Science Society of America, Madison, Wisconsin, pp. 1085-1022.

Subbiah, B.V. and Asija, G.L. (1956) A rapid procedure for the determination of available nitrogen in soils. Current Science 25, 259-260.
}
