% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kroyeri.R
\docType{data}
\name{kroyeri}
\alias{kroyeri}
\title{Vocalization of the frog \emph{Physalaemus kroyeri}}
\format{
An object of the class \code{"Wave"} (\code{\link[tuneR]{tuneR}} package).
}
\source{
Original recording housed at Fonoteca Neotropical Jacques Vielliard (FNJV-0032047). Recorded by Werner Bokermann.
}
\usage{
data(kroyeri)
}
\description{
Recording of a series of three stereotyped calls emitted by a male frog \emph{Physalaemus kroyeri} (Amphibia, Anura, Leptodactylidae). Edited from original \code{".wav"} file for optimal sinal to noise ratio and reduced time duration.
}
\details{
Duration = 3.91 s. Sampling Frequency = 44100 Hz.

Recorded at Ilhéus Municipality, Bahia State, Brazil, on 05 August 1972. Air temperature 24ºC.
}
\examples{
data(kroyeri)

seewave::oscillo(kroyeri)
seewave::spectro(kroyeri)
threeDspectro(kroyeri,tlim=c(0, 1), flim=c(0, 4), samp.grid=FALSE, dBlevel=25)
}
\keyword{datasets}
