% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weather}
\alias{weather}
\title{Weather variables}
\format{
A data frame in messy format with 504 observations on the following 5 variables:
\describe{
\item{\code{location}}{locations, 63 levels (observed locations in the historical series)}
\item{\code{LON}}{longitude}
\item{\code{LAT}}{latitude}
\item{\code{DOY}}{day of the year}
\item{\code{YYYYMMDD}}{calendar date in the format YYYY/MM/DD}
\item{\code{daysFromStart}}{days from average planting date}
\item{\code{T2M}}{daily average temperature at 2 meters}
\item{\code{T2M_MAX}}{daily maximum temperature at 2 meters}
\item{\code{T2M_MIN}}{daily minimum average temperature at 2 meters}
\item{\code{PRECTOT}}{rainfall precipitation}
\item{\code{WS2M}}{wind speed at 2 meters}
\item{\code{RH2M}}{relative humidity at 2 meters}
\item{\code{T2MDEW}}{dew point at 2 meters}
\item{\code{ALLSKY_SFC_LW_DWN}}{downward thermal infrared (longwave) radiative flux}
\item{\code{ALLSKY_SFC_SW_DWN}}{insolation incident on a horizontal surface}
\item{\code{n}}{duration of sunshine in hours}
\item{\code{VPD}}{the deficit of vapor pressure}
\item{\code{SPV}}{the slope of saturation vapor pressure curve}
\item{\code{ETP}}{evapotranspiration}
\item{\code{PETP}}{deficit of evapotranspiration}
\item{\code{GDD}}{growing degree-days}
\item{\code{FRUE}}{effect of temperature on radiation use efficiency}
\item{\code{T2M_RANGE}}{daily temperature range at 2 meters}
\item{\code{PTT}}{photothermal time (GDD \eqn{\times} daylight in hours)}
\item{\code{PTR}}{photothermal ratio (GDD / daylight in hours)}
}
}
\source{
\describe{
Krause, M. D., Dias, K. O. G., Singh, A. K., and Beavis. W. D. (2022). Using large
soybean historical data to study genotype by environment variation and
identify mega-environments with the integration of genetic and non-genetic
factors. bioRxiv, \doi{doi:10.1101/2022.04.11.487885}
}
}
\usage{
weather
}
\description{
Weather variables obtained from NASA's Prediction of Worldwide Energy
Resource (\url{https://power.larc.nasa.gov/}) for the 591 environments in
the historical series analyzed by Krause et al. (2022).
}
\note{
\describe{
Comprehensive R Archive Network (CRAN) policy limits R package size to 5 Mb.
In order to give the users new opportunities of data analysis, we provide
weather data for all combinations of locations (63) and years (31), resulting in
information for 1,953 environments. If an environment was not observed in a
given year, weather data was retrieved with the average planting and maturity
data based on the empirical data for that location. This data set can be downloaded
\href{https://drive.google.com/file/d/19wS0RWA3NX-lSJJ23OgvLoPV-TI1xKIg/view?usp=sharing}{here}.
}
}
\keyword{datasets}
