% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectSynonyms.R
\name{objectSynonyms}
\alias{objectSynonyms}
\title{Identify synonyms in a \code{simList}}
\usage{
objectSynonyms(envir, synonyms)
}
\arguments{
\item{envir}{An environment, which in the context of SpaDES.core is usually
a \code{simList} to find and/or place the \code{objectSynonyms}
object.}

\item{synonyms}{A list of synonym character vectors, such as
\code{list(c("age", "ageMap", "age2"), c("veg", "vegMap"))}}
}
\value{
Active bindings in the \code{envir} so that all synonyms point to the same
canonical object, e.g., they would be at \code{envir[[synonym[[1]][1]]]} and
\code{envir[[synonym[[1]][2]]]}, if a list of length one is passed into
\code{synonyms}, with a character vector of length two. See examples.
}
\description{
This will create active bindings amongst the synonyms. To minimize copying,
the first one that exists in the character vector will become the "canonical"
object. All others named in the character vector will be \code{activeBindings} to
that canonical one.  This synonym list will be assigned to the \code{envir},
as an object named \code{objectSynonyms}. That object will have an attribute
called, \code{bindings} indicating which one is the canonical one and which
is/are the \code{activeBindings.} EXPERIMENTAL: If the objects are removed during a
\code{spades} call by, say, a module, then at the end of the event, the
\code{spades} call will replace the bindings. In other words, if a module
deletes the object, it will "come back". This may not always be desired.
}
\details{
This is very experimental and only has minimal tests. Please report if this is
not working, and under what circumstances (e.g., please submit a reproducible example
to our issues tracker)

This function will append any new \code{objectSynonym} to any pre-existing
\code{objectSynonym} in the \code{envir}. Similarly, this function assumes
transitivity, i.e., if \code{age} and \code{ageMap} are synonyms, and \code{ageMap} and \code{timeSinceFire}
are synonyms, then \code{age} and \code{timeSinceFire} must be synonyms.
}
\examples{
sim <- simInit()

sim$age <- 1:10;
sim <- objectSynonyms(sim, list(c("age", "ageMap")))

identical(sim$ageMap, sim$age)
sim$age <- 4
identical(sim$ageMap, sim$age)
sim$ageMap <- 2:5
sim$ageMap[3] <- 11
identical(sim$ageMap, sim$age)

# Also works to pass it in as an object
objectSynonyms <- list(c("age", "ageMap"))
sim <- simInit(objects = list(objectSynonyms = objectSynonyms))
identical(sim$ageMap, sim$age) # they are NULL at this point
sim$age <- 1:10
identical(sim$ageMap, sim$age) # they are not NULL at this point

## More complicated, with 'updating' i.e., you can add new synonyms to previous
sim <- simInit()
os <- list(c("age", "ageMap"), c("vegMap", "veg"), c("studyArea", "studyArea2"))
os2 <- list(c("ageMap", "timeSinceFire", "tsf"),
            c("systime", "systime2"),
            c("vegMap", "veg"))
sim <- objectSynonyms(sim, os)
sim <- objectSynonyms(sim, os2)

# check
sim$.objectSynonyms

}
