% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupICA.R
\name{create_group_list}
\alias{create_group_list}
\title{Create a List of fMRI Files for Group ICA Analysis}
\usage{
create_group_list(bids_path, pattern = "task-rest.*\\\\.dtseries\\\\.nii$")
}
\arguments{
\item{bids_path}{A character string specifying the path to the root directory of the BIDS-formatted dataset. This directory should contain subject folders (e.g., \code{sub-*}).}

\item{pattern}{A character string specifying the pattern to match fMRI files. The default is \code{"task-rest.*\\.dtseries\\.nii$"}.}
}
\value{
A named list where each element corresponds to a subject directory and contains a vector of matched fMRI file paths. The names of the list are the subject IDs.
}
\description{
This function scans a BIDS-formatted directory for subject-specific fMRI files that match a specified pattern 
and returns a list of these files for use in group ICA analysis.
}
\examples{
# Example usage:
# Assuming `bids_dir` is the path to a BIDS dataset:
# group_list <- create_group_list(bids_path = bids_dir, pattern = "task-rest.*\\.dtseries\\.nii$")
# Print the structure of the list:
# str(group_list)

}
