% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interGradientsDL.R
\name{plotHeatmapGradsAgg}
\alias{plotHeatmapGradsAgg}
\title{Plot a heatmap of gradients of classes / loss function wtih respect to the
input}
\usage{
plotHeatmapGradsAgg(
  object,
  method = "class",
  top.n.genes = 15,
  scale.gradients = TRUE
)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with a
\code{\linkS4class{DeconvDLModel}} object containing gradients in the
\code{interpret.gradients} slot.}

\item{method}{Method to calculate gradients with respect to input features.
It can be
\code{'class'} (gradients of predicted classes w.r.t. input features) or
\code{'loss'} (gradients of loss w.r.t. input features) (\code{'class'} by
default).}

\item{top.n.genes}{Top n genes (positive and negative) taken per cell type.}

\item{scale.gradients}{Whether to calculate feature-wise z-scores of
gradients (\code{TRUE} by default).}
}
\value{
A list of \code{Heatmap-class} objects, one for top
positive and another one for top negative gradients.
}
\description{
Plot a heatmap showing the top positive and negative gene average
gradients per cell type.
}
\examples{
\donttest{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 10,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(10)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(10)),
    Cell_Type = sample(x = paste0("CellType", seq(2)), size = 10,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE
)
SDDLS <- genMixedCellProp(
  object = SDDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  num.sim.spots = 50,
  train.freq.cells = 2/3,
  train.freq.spots = 2/3,
  verbose = TRUE
)
SDDLS <- simMixedProfiles(SDDLS)
SDDLS <- trainDeconvModel(
  object = SDDLS,
  batch.size = 12,
  num.epochs = 5
)
## calculating gradients
SDDLS <- interGradientsDL(SDDLS)
plotHeatmapGradsAgg(SDDLS, top.n.genes = 2)
}
  
}
\seealso{
\code{\link{interGradientsDL}} \code{\link{trainDeconvModel}}
}
