% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unet.R
\name{predict.UNet}
\alias{predict.UNet}
\title{Predict function for UNet model}
\usage{
\method{predict}{UNet}(object, newdata, time_points = NULL, ...)
}
\arguments{
\item{object}{A UNet model object.}

\item{newdata}{Array or list of arrays. New data to predict on in format (x, y, time).}

\item{time_points}{An optional numeric vector containing the time points of the new data.}

\item{...}{Additional arguments (not used).}
}
\value{
Array of predictions in format (x, y, time).
}
\description{
This function generates predictions using a trained UNet model.
}
\details{
The predict function applies the trained UNet model to new coarse data.
It performs denormalization if the model was trained with normalization.
}
\examples{

\donttest{
 # Create tiny dummy data:
 # Coarse grid: 8x8 → Fine grid: 16x16
 nx_c <- 8 
 ny_c <- 8
 nx_f <- 16
 ny_f <- 16
 T <- 5  # number of time steps
 
 # Coarse data:
 coarse_data <- array(runif(nx_c * ny_c * T),
                      dim = c(nx_c, ny_c, T))
 
 # Fine data:
 fine_data <- array(runif(nx_f * ny_f * T),
                    dim = c(nx_f, ny_f, T))
 
 # Optional time points
 time_points <- 1:T
 
 # Fit a tiny UNet (very small filters to keep the example fast)
 model_obj <- unet(
   coarse_data,
   fine_data,
   time_points = time_points,
   filters = c(8, 16),
   initial_filters = c(4),
   epochs = 1,
   batch_size = 4,
   verbose = 0
 )
 
 T_new <- 3
 newdata <- array(runif(nx_c * ny_c * T_new),
                      dim = c(nx_c, ny_c, T_new))
 predictions <- predict(model_obj, newdata, 1:T_new)
}

}
\seealso{
\code{\link{unet}} for fitting UNet model.
}
