% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finemeshed2d.R
\name{finemeshed2d}
\alias{finemeshed2d}
\title{finemeshed2d}
\usage{
finemeshed2d(
  x,
  n.breaks1 = 1000,
  n.breaks2 = 1000,
  round.breaks1 = 9,
  round.breaks2 = 9
)
}
\arguments{
\item{x}{vector or one column matrix to scale. This vector comes from the vectorization of the
matrices to be transformed. x is named using the concatenation of the names of the rows and
the names of the columns of the matrix to be transformed, as shown in the example below.}

\item{n.breaks1}{integer. Number of breaks needed for the first variable.
The variable for which classes are in first position when constructing x's names is the first variable.}

\item{n.breaks2}{integer. Number of breaks needed for the second variable. The variable for which classes are
in second position when constructing x's names is the second variable.}

\item{round.breaks1}{integer. Number of decimals for breaks of the first variable.}

\item{round.breaks2}{integer. Number of decimals for breaks of the second variable.}
}
\value{
Returns:
\describe{
\item{finemeshed.matrix}{Matrix of dimension n.breaks2 x n.breaks1. The row and column names of finemeshed.matrix are the
breaks created from each variable and the associated n.breaks. Each value of finemeshed.matrix is equal to the value of
x indexed by the classes containing the row and column names of finemeshed.matrix}
\item{finemeshed.values1}{First variable breaks}
\item{finemeshed.values2}{Second variable breaks}
}
}
\description{
Function that helps to transform  a vector into a matrix (with a fine mesh). In the implementation of the spiceFP approach,
it allows to transform matrices of coefficients having different dimensions into matrices of the
same dimension in order to perform arithmetic operations. In practice, the matrix to be transformed is
associated with a contingency table, which implies numerical variables for which classes have been created.
}
\details{
This function is designed to return a fine meshed matrix and breaks associated.
In order to obtain a fine mesh, a high number of breaks must be fixed.
}
\examples{
set.seed(45)
count_table<- hist_2d(x = rnorm(1000),
                      y = rnorm( 1000,5,0.1),
                      breaks_x = seq(-4, 4, by =1),
                      breaks_y = seq(2, 8, by =1))$Hist.Values

df.x<-as.data.frame.table(count_table)
x<-df.x$Freq
names(x)<-paste0(df.x$Var1,"_",df.x$Var2)

res.fm2d <- finemeshed2d(x,100,100)
dim(res.fm2d$finemeshed.matrix)
}
