% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_sporulation.R
\name{predict_sporulation}
\alias{predict_sporulation}
\title{Predict Sporulation Potential}
\usage{
predict_sporulation(binary_matrix)
}
\arguments{
\item{binary_matrix}{A binary matrix (1/0) indicating gene presence/absence for each MAG. Must include a \code{genome_ID} column.}
}
\value{
A tibble with predicted class and probability of sporulation for each genome.
}
\description{
This function predicts the sporulation potential of MAGs using an ensemble learning model.
It uses probabilities from Random Forest and SVM classifiers as inputs to a meta-model.
}
\examples{
# Load package
library(SpoMAG)

# Load example annotation tables
file_spor <- system.file("extdata", "one_sporulating.csv.gz", package = "SpoMAG")
file_aspo <- system.file("extdata", "one_asporogenic.csv.gz", package = "SpoMAG")

# Read files
df_spor <- readr::read_csv(file_spor, show_col_types = FALSE)
df_aspo <- readr::read_csv(file_aspo, show_col_types = FALSE)

# Step 1: Extract sporulation-related genes
genes_spor <- sporulation_gene_name(df_spor)
genes_aspo <- sporulation_gene_name(df_aspo)

# Step 2: Convert to binary matrix
bin_spor <- build_binary_matrix(genes_spor)
bin_aspo <- build_binary_matrix(genes_aspo)

# Step 3: Predict using ensemble model (preloaded in package)

result_spor <- predict_sporulation(bin_spor)
result_aspo <- predict_sporulation(bin_aspo)

 
}
