% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rh_stan.R
\name{rh_stan}
\alias{rh_stan}
\title{Bayesian Renshaw-Haberman model with Stan}
\usage{
rh_stan(
  death,
  exposure,
  forecast,
  validation = 0,
  family = c("poisson", "nb"),
  ...
)
}
\arguments{
\item{death}{Matrix of deaths.}

\item{exposure}{Matrix of exposures.}

\item{forecast}{Number of years to forecast.}

\item{validation}{Number of years for validation.}

\item{family}{specifies the random component of the mortality model. \code{"Poisson"} assumes a
Poisson model with log link and \code{"nb"} assumes a negative-binomial model
with log link and overdispersion parameter \eqn{\phi}.}

\item{...}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
An object of class \code{stanfit} returned by \code{rstan::sampling}.
}
\description{
Fit and Forecast Bayesian Renshaw-Haberman model (Lee-Carter with cohort effect) introduced in Renshaw and Haberman (2006).
The model can be fitted with a Poisson or Negative-Binomial distribution. The function outputs posteriors distributions for each parameter,
predicted death rates and log-likelihoods.
}
\details{
The created model is either a log-Poisson or a log-Negative-Binomial version of
the Renshaw-Haberman model:
\deqn{D_{x,t} \sim \mathcal{P}(\mu_{x,t} e_{x,t})}
or
\deqn{D_{x,t}\sim NB\left(\mu_{x,t} e_{x,t},\phi\right)}
with
\deqn{\log \mu_{xt} = \alpha_x + \beta_x\kappa_t+\gamma_{t-x}.}

To ensure the identifiability of th model, we impose
\deqn{\kappa_1=0, \gamma_1=0,\sum gamma_i =0, \gamma_C=0,}
where \eqn{C} represents the most recent cohort in the data.

For the priors, the model chooses wide priors:
\deqn{\alpha_x \sim N(0,100),\beta_{x} \sim Dir(1,\dots,1),\frac{1}{\phi} \sim Half-N(0,1).}

For the period term, we consider the standard random walk with drift:
\deqn{\kappa_{t}=c+\kappa_{t-1}+\epsilon_{t},\epsilon_{t}\sim N(0,\sigma^2)}
with \eqn{c \sim N(0,10),\sigma \sim Exp(0.1)}.

For the cohort term, we consider a second order autoregressive process (AR(2)):
\deqn{\gamma_{c}=\psi_1 \gamma_{c-1}+\psi_2 \gamma_{c-2}+\epsilon^{\gamma}_{t},\quad \epsilon^{\gamma}_{t}\sim N(0,\sigma_{\gamma}).}

To close the model specification, we impose some vague priors assumptions on the hyperparameters:
\deqn{\psi_1,\psi_2 \sim N(0,10),\quad \sigma_{\gamma}\sim Exp(0.1).}
}
\examples{


#10-year forecasts for French data for ages 50-90 and years 1970-2017 with a log-Poisson model
ages.fit<-70:90
years.fit<-1990:2010
deathFR<-FRMaleData$Dxt[formatC(ages.fit),formatC(years.fit)]
exposureFR<-FRMaleData$Ext[formatC(ages.fit),formatC(years.fit)]
iterations<-50 # Toy example, consider at least 2000 iterations
fitRH=rh_stan(death = deathFR,exposure=exposureFR, forecast = 5, family = "poisson",
iter=iterations,chains=1)


}
\references{
Renshaw, A. E., & Haberman, S. (2006). A cohort-based extension to the
Lee-Carter model for mortality reduction factors.
Insurance: Mathematics and Economics, 38(3), 556-570.
}
