% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_obs.R
\name{get_obs}
\alias{get_obs}
\title{Read STICS observation files (*.obs)}
\usage{
get_obs(
  workspace,
  usm = NULL,
  var = NULL,
  dates = NULL,
  usms_file = NULL,
  javastics = NULL,
  verbose = TRUE,
  usm_name = lifecycle::deprecated(),
  var_list = lifecycle::deprecated(),
  dates_list = lifecycle::deprecated(),
  usms_filepath = lifecycle::deprecated(),
  javastics_path = lifecycle::deprecated()
)
}
\arguments{
\item{workspace}{Vector of path(s) of directory(ies) containing the STICS
observation files to read (*.obs file) or path of a single directory
containing one sub-folder per USM (named as the USM names),
each of them containing the corresponding files to read.
In the second case, the argument \code{usm} must also be provided.}

\item{usm}{Vector of USM names. Optional, if not provided, the function
returns the results for all USMs.}

\item{var}{Vector of variable names for which results have to be provided.
Optional, all variables considered by default. See \code{get_var_info()}
to get the list of STICS variables names.}

\item{dates}{list of dates to filter (POSIX date)}

\item{usms_file}{Path of a USM xml file. Optional, if provided, the plant
names are added in the Plant column (see details).}

\item{javastics}{Path of JavaSTICS. Optional, should be provided in addition
to usms_file to get the plant codes if the plant files used are not
in the workspace but in the JavaSTICS distribution (see Details).}

\item{verbose}{Logical value for displaying or not information while running}

\item{usm_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usm_name} is no
longer supported, use \code{usm} instead.}

\item{var_list}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{var_list} is no
longer supported, use \code{var} instead.}

\item{dates_list}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{dates_list} is no
longer supported, use \code{dates} instead.}

\item{usms_filepath}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_filepath} is no
longer supported, use \code{usms_file} instead.}

\item{javastics_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{javastics_path}
is no longer supported, use \code{javastics} instead.}
}
\value{
A list, where each element is a \code{data.frame} of observations
for the given usm. The list is named after the USM name.

Intercrops are returned in a single \code{data.frame}, and are identified
using either the "Plant" or "Dominance" columns.

See Details section for more information about the "Plant" column.
}
\description{
Read STICS observation files from a JavaSTICS workspace and
store data into a list per usm
}
\details{
\strong{The \code{.obs} files names must match USMs names}, \emph{e.g.} for a usm
called "banana", the \code{.obs} file should be named \code{banana.obs}.
For intercrops, the name should be suffixed by "p" for the principal
and "a" for the associated plant.

If \code{usm} is not specified (or equal to \code{NULL}), the
function reads the files from all usms in the \code{workspace}(s).

If \code{usms_file} is provided and if the associated plant file is found,
the plant names in the "Plant" column of the generated \code{data.frame}
are either the plant code (as specified in the plant file) or
the name of the plant file, if the plant file is not found.

If \code{usms_file} is not specified, the plants are named "plant_1"
by default (+ "plant_2" for intercrops).
}
\examples{

path <- file.path(get_examples_path(file_type = "obs"), "mixed")

# Get observations for all usms, but only banana has observations:
Meas <- get_obs(path)

# Get observations only for banana:
Meas_banana <- get_obs(path, "banana")

\dontrun{
# Get observations with real plant names when plant
# folder is not in the workspace:
get_obs(path, "banana", javastics = "/path/to/JavaSTICS/folder")
}

}
