% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_opportunities.R
\name{extract_opportunities}
\alias{extract_opportunities}
\title{Compute the number of opportunities between pairs of locations}
\usage{
extract_opportunities(opportunity, distance, check_names = FALSE)
}
\arguments{
\item{opportunity}{A \code{numeric} vector representing the number of opportunities
per location. The value should be positive.}

\item{distance}{A squared \code{matrix} representing the distances between
locations.}

\item{check_names}{A \code{boolean} indicating whether the location IDs are used
as \code{vector} names, \code{matrix} row names, and \code{matrix} column names, and
whether they should be checked (see Note).}
}
\value{
A squared \code{matrix} in which each element represents the number of
opportunities between a pair of locations.
}
\description{
This function computes the number of opportunities between pairs of locations
as defined in Lenormand \emph{et al.} (2016). For a given pair of locations,
the number of opportunities between the origin location and the destination
location is based on the number of opportunities within a circle of radius
equal to the distance between the origin and the destination, with the
origin location as the center. The number of opportunities at the origin
and destination locations are not included.
}
\note{
\code{opportunity} and \code{distance} should be based on the same number of
locations sorted in the same order. It is recommended to use the location ID
as \code{matrix} \code{rownames} and \code{matrix} \code{colnames} and to set
\code{check_names = TRUE} to verify that everything is consistent before running
this function (\code{check_names = FALSE} by default). Note that the function
\code{\link[=check_format_names]{check_format_names()}} can be used to validate all inputs
before running the main package's functions.
}
\examples{
data(mass)
data(distance)

opportunity <- mass[, 1]

sij <- extract_opportunities(opportunity = opportunity,
                             distance = distance,
                             check_names = FALSE)

}
\references{
Lenormand M, Bassolas A, Ramasco JJ (2016) Systematic comparison of trip
distribution laws and models. \emph{Journal of Transport Geography} 51,
158-169.
}
\seealso{
Associated functions:
\code{\link[=extract_distances]{extract_distances()}}, \code{\link[=extract_spatial_information]{extract_spatial_information()}}.
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
