% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/THREC.R
\name{main_species}
\alias{main_species}
\title{Main species generalized function response calibration}
\usage{
main_species(DATA)
}
\arguments{
\item{DATA}{data frame containing at least yta, rev, t_l, dia, QMD, G, hdom, and hojd.}
}
\value{
data frame with estimated height
}
\description{
This function performs a response calibration for main species at once. The main species include Scots pine, Norway spruce, and birch.
}
\note{
yta: plot number, rev: revision, t_l: species code, dia: diameter at breast height, QMD: quadratic mean diameter, G: basal area per ha, hdom: height of the tree with the largest diameter (ddom) regardless of the species (m), hojd: sample tree height with missing values. In cases where hdom is not present in the inventory data, site index (SI) can serve as an alternative, although the estimated height may exhibit slight variations.
}
\examples{
library(THREC)

# sample data
data(Treeht)

main_species(Treeht)
}
\references{
Ogana et al. (2023) https://doi.org/10.1016/j.foreco.2023.120843

Arias-Rodil et al. (2015) https://doi.org/10.1371/JOURNAL.PONE.0143521
}
\seealso{
\code{\link[=species_specific]{species_specific()}}, which estimate the tree height of the main species based on species-specific height functions.
}
\author{
Ogana F.N. and Arias-Rodil M.
}
\keyword{main_species}
