% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dif.R
\name{plot_dif}
\alias{plot_dif}
\title{Plot Interior Spatial Locations and System Boundary - 2D Map}
\usage{
plot_dif(coords, h, v, xlab = NULL, ylab = NULL, title = NULL, cex = 1)
}
\arguments{
\item{coords}{data frame; should only contain the two variables: X coordinate and Y coordinate. Each row uniquely
denotes a spatial location. (coordinates must be numeric)}

\item{h}{numeric; side length of the unit grid in X coordinate direction.}

\item{v}{numeric; side length of the unit grid in Y coordinate direction.}

\item{xlab}{a label for the x axis, defaults to the name of X coordinate.}

\item{ylab}{a label for the y axis, defaults to the name of Y coordinate.}

\item{title}{a main title for the plot.}

\item{cex}{numeric; size of plotting point for each spatial location. (default: 1)}
}
\description{
\code{plot_dif} differentiates boundary and interior spatial locations in a spatial domain (a collection of
spatial locations with their coordinates). Since TSCS method is only capable of interpolation but not
extrapolation, it is necessary to highlight the difference between interior spatial locations and system boundary.
}
\details{
\code{plot_dif} is exclusive to 2D rectangular grid system. Similarly, if you want to fathom how this package
  handles 3D rectangular grid system, please refer to \code{plot3D_dif}.
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression(data = data, h = 1, v = 1, alpha = 0.01); # regression
basis$percentage # see the percentage of cointegrated relationships
est <- tscsEstimate(matrix = basis$coef_matrix, newdata = newdata, h = 1, v = 1); # estimation
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,3], true = true) # graphic comparison
index <- appraisal_index(est = est$estimate[,3], true = true); # RMSE & std
index

## data visualization:

plot_dif(data = data[,1:2], h = 1, v = 1) # differentiate boundary and interior spatial locations
plot_NA(newdata = newdata) # show spatial locations with missing value, for a cross-section data
plot_map(newdata = newdata) # plot the 2D spatial map, for a cross-section data
}
}
\seealso{
\code{\link{plot3D_dif}}, \code{\link{plot_NA}}, \code{\link{plot_map}}
}
