% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscsEstimate.R
\name{tscsEstimate}
\alias{tscsEstimate}
\title{The Second Step of TSCS for 2D Rectangular Grid System - Estimation}
\usage{
tscsEstimate(matrix, newdata, h, v)
}
\arguments{
\item{matrix}{data frame; the first return value \code{coef_matrix} of function \code{tscsRegression}
in the first step of TSCS.}

\item{newdata}{data frame; should only contain the three variables in order: X coordinate, Y coordinate and observation.
This is the cross-section data or pure spatial data of a particular time point you have selected,
with missing observations that you want to predict. (coordinates must be numeric)}

\item{h}{numeric; side length of the unit grid in X coordinate direction.}

\item{v}{numeric; side length of the unit grid in Y coordinate direction.}
}
\value{
A list of 3 is returned, including:
\describe{
  \item{\code{estimate}}{data frame; estimate of missing observations which contains the 3 variables in order:
  X coordinate, Y coordinate and estimation.}
  \item{\code{complete}}{data frame; an updated version of the cross-section data (pure spatial data) \code{newdata},
  with all of its missing observations interpolated.}
  \item{\code{NA_id}}{an integer vector; reveals the instance ID, in data frame \code{newdata},
  of spatial locations with missing observation.}
}
}
\description{
\code{tscsEstimate} estimates the missing observations within the cross-section data (pure spatial data)
  of a particular time point you have selected, namely, the interpolation process.
}
\details{
\itemize{
  \item The first step of TSCS spatial interpolation should be carried out by function \code{tscsRegression},
  which is the prerequisite of \code{tscsEstimate}.
  \item For 3D rectangular grid system, the procedure of TSCS stays the same.
  Please see \code{tscsRegression3D} and \code{tscsEstimate3D}.
  \item Attentions:
  Since TSCS is only capable of interpolation but not extrapolation, please make sure that
  the missing observations in a given spatial domain are all located at interior spatial locations.
  Otherwise, extrapolation would occur with an error following.
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression(data = data, h = 1, v = 1, alpha = 0.01); # regression
basis$percentage # see the percentage of cointegrated relationships
est <- tscsEstimate(matrix = basis$coef_matrix, newdata = newdata, h = 1, v = 1); # estimation
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,3], true = true) # graphic comparison
index <- appraisal_index(est = est$estimate[,3], true = true); # RMSE & std
index

## data visualization:

plot_dif(data = data[,1:2], h = 1, v = 1) # differentiate boundary and interior spatial locations
plot_NA(newdata = newdata) # show spatial locations with missing value, for a cross-section data
plot_map(newdata = newdata) # plot the 2D spatial map, for a cross-section data
}
}
\seealso{
\code{\link{tscsRegression}}, \code{\link{tscsEstimate3D}}, \code{\link{plot_NA}}, \code{\link{plot_map}}
}
