% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.r
\name{processing}
\alias{processing}
\title{Time series data processing}
\usage{
processing(
  prep_func,
  prep_par = NULL,
  postp_func = NULL,
  postp_par = NULL,
  ...,
  subclass = NULL
)
}
\arguments{
\item{prep_func}{A function for preprocessing the time series data.}

\item{prep_par}{List of named parameters required by \code{prep_func}.}

\item{postp_func}{A function for postprocessing the time series data.
Generally reverses the transformation performed by \code{prep_func}.}

\item{postp_par}{List of named parameters required by \code{postp_func}.}

\item{...}{Other parameters to be encapsulated in the class object.}

\item{subclass}{Name of new specialized subclass object created in case it is provided.}
}
\value{
An object of class \code{processing}.
}
\description{
Constructor for the \code{processing} class representing a time series
processing method based on a particular time series transformation.
}
\examples{
base <- exp(1)
lt <- processing(prep_func=TSPred::LogT, prep_par=list(base=base),
                 postp_func=TSPred::LogT.rev, postp_par=list(base=base),
                 method="Logarithmic transform", subclass="LT")
summary(lt)

}
\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{LT}()},
\code{\link{MSE_eval}()},
\code{\link{evaluating}()},
\code{\link{modeling}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{postprocessing}
\keyword{preprocessing}
\keyword{processing}
\keyword{transformation}
