% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{make_swc}
\alias{make_swc}
\title{make_swc}
\usage{
make_swc(rain, pet, fc, wp, seconds, iterations)
}
\arguments{
\item{rain}{matrix with ntimesteps rows, nsites columns, containing precipitation [kg*m^(-2)*s^(-1)]}

\item{pet}{matrix with ntimesteps rows, nsites columns, containing potential evapotranspiration [kg*m^(-2)*s^(-1)]}

\item{fc}{vector of length nsites containing the field capacity [cm^3/cm^3]}

\item{wp}{vector of length nsites containing the wilting point [cm^3/cm^3]}

\item{seconds}{number of seconds in a time step}

\item{iterations}{number of times to run through the data, default is 3}
}
\value{
matrix with ntimesteps rows, nsites columns, containing a soil water content index scaled from 0-100
}
\description{
Creates soil water content index from input precipitation,
potential evapotranspiration, field capacity and wilting point.
}
\details{
This function is called internally by \code{get_input()}.
}
