% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aic_fit_2d.R
\name{get_aic_fit_2d}
\alias{get_aic_fit_2d}
\title{Return the AIC of 2ts model}
\usage{
get_aic_fit_2d(
  lrho,
  R,
  Y,
  Z = NULL,
  Bu,
  Bs,
  Iu,
  Is,
  Du,
  Ds,
  Wprior = NULL,
  ridge = 0,
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE, monitor_ev =
    FALSE)
)
}
\arguments{
\item{lrho}{A vector of two elements, the initial values for \eqn{\log_{10}(\varrho_u)}
and \eqn{\log_{10}(\varrho_s)}.}

\item{R}{A matrix (or 3d-array) of exposure times of dimension nu by ns
(or nu by ns by n).}

\item{Y}{A matrix (or 3d-array) of event counts of dimension nu by ns
(or nu by ns by n).}

\item{Z}{(optional) A regression matrix of covariates values of dimensions
n by p.}

\item{Bu}{A matrix of B-splines for the \code{u} time scale of dimension nu by cu.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{Iu}{An identity matrix of dimension nbu by nbu.}

\item{Is}{An identity matrix of dimension nbs by nbs.}

\item{Du}{The difference matrix over \code{u}.}

\item{Ds}{The difference matrix over \code{s}.}

\item{Wprior}{An optional matrix of a-priori weights.}

\item{ridge}{A ridge penalty parameter: default is 0. This is useful when, in
some cases the algorithm shows convergence problems. In this case, set to a small
number, for example \code{1e-4}.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}
}
\value{
The \code{aic} value of the fitted model.
}
\description{
\code{get_aic_fit_2d()} fits the 2ts model with or without individual
level covariates and it returns the AIC of the model.
See also \code{fit2tsmodel_ucminf()} and \code{fit2ts()}.
}
