% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_search_1d.R
\name{grid_search_1d}
\alias{grid_search_1d}
\title{Grid search for the optimal 1ts model}
\usage{
grid_search_1d(
  r,
  y,
  Z = NULL,
  lrho,
  Bs,
  Ds,
  Wprior = NULL,
  optim_criterion = c("aic", "bic"),
  control_algorithm = list(maxiter = 20, conv_crit = 1e-05, verbose = FALSE, monitor_ev =
    FALSE),
  par_gridsearch = list(plot_aic = FALSE, plot_bic = FALSE, return_aic = TRUE, return_bic
    = TRUE, mark_optimal = TRUE, main_aic = "AIC grid", main_bic = "BIC grid")
)
}
\arguments{
\item{r}{A vector of exposure times of length ns, or an array of dimension ns
by n.}

\item{y}{A vector of event counts of length ns, or an array of dimension ns
by n.}

\item{Z}{(optional) A regression matrix of covariates of dimension n by p.}

\item{lrho}{A vector of \code{log_10(rho_s)} values.}

\item{Bs}{A matrix of B-splines for the time scale \code{s}.}

\item{Ds}{The difference matrix of the penalty.}

\item{Wprior}{An optional vector of a-priori weights.}

\item{optim_criterion}{The criterion to be used for optimization:
\code{"aic"} (default) or \code{"bic"}. BIC penalized model complexity more strongly
than AIC, so that its usage is recommended when a smoother fit is preferable
(see also Camarda, 2012).}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}

\item{par_gridsearch}{A list of parameters for the grid_search:
\itemize{
\item \code{plot_aic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the AIC values
over the grid of \code{log_10(rhos)} values.
\item \code{plot_bic} A Boolean. Default is \code{FALSE}. If \code{TRUE}, plot the BIC values
over the grid of \code{log_10(rhos)} values.
\item \code{return_aic} A Boolean. Default is \code{TRUE}. Return the AIC values.
\item \code{return_bic} A Boolean. Default is \code{TRUE}. Return the BIC values.
\item \code{mark_optimal} A Boolean. Default is \code{TRUE}. If the plot of the AIC or BIC
values is returned, marks the optimal \code{log_10(rho_s)} in the plot.
\item \code{main_aic} The title of the AIC plot. Default is \code{"AIC grid"}.
\item \code{main_bic} The title of the BIC plot. Default is \code{"BIC grid"}.
}}
}
\value{
An object of class \code{h1tsfit} with the following elements:
\itemize{
\item \code{optimal_model} A list containing the results of the optimal model.
\item \code{optimal_logrho} The optimal value of \code{log10(rho_s)}.
\item \code{P_optimal} The optimal penalty matrix P.
\item \code{AIC} (if \code{par_gridsearch$return_aic == TRUE}) The vector of AIC values.
\item \code{BIC} (if \code{par_gridsearch$return_bic == TRUE}) The vector of BIC values.
}
}
\description{
\code{grid_search_1d()} performs a grid search for the minimum
AIC or BIC of the one time scale model.

It finds the optimal values of \code{log_10(rho_s)} and returns the estimated
optimal model.
}
\references{
Camarda, C. G. (2012). "MortalitySmooth: An R Package for
Smoothing Poisson Counts with P-Splines."
Journal of Statistical Software, 50(1), 1–24.
https://doi.org/10.18637/jss.v050.i01
}
