% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_slices.R
\name{plot_slices}
\alias{plot_slices}
\title{Plot slices of the (log-) hazard}
\usage{
plot_slices(x, y, direction, plot_options = list())
}
\arguments{
\item{x}{A vector of values for the x-axis. This is a vector of values over
the axis opposite to the one where the sliced are cut.}

\item{y}{A matrix of (log-)hazard values.}

\item{direction}{Either \code{"u"} or \code{"s"}.}

\item{plot_options}{A list of options for the plot:
\itemize{
\item \code{loghazard} A Boolean. Default is \code{FALSE}. If \code{FALSE} the function
returns a plot of cross-sections from the hazard surface,
if \code{TRUE} the function returns a plot of cross-sections from the
log-hazard surface.
\item \code{log10hazard} A Boolean. Default is \code{FALSE}. If \code{TRUE} returns a plot of
cross-sections from the log10-hazard surface.
\item \code{col_palette} A function defining the color palette. The default palette
is \code{grDevices::gray.colors()}.
\item \code{n_shades} The number of color shades to plot, default is 50.
\item \code{main} The title of the plot.
\item \code{xlab} The label of the first time axis (plotted on the x axis).
\item \code{ylab} The label of the second time axis (plotted on the y axis).
\item \code{xlim} A vector with two elements defining the limits of the time scale
on the x axis.
\item \code{ylim} A vector with two elements defining the limits of the time scale
on the y axis.
\item \code{cex_main} The magnification to be used for the main title, default is \code{1.2}.
\item \code{cex_lab} The magnification to be used for the axis labels, default is \code{1}.
\item \code{lwd} The line's width. Default is \code{2}.
}}
}
\value{
A plot of the slices of the hazard cut at selected points.
}
\description{
\code{plot_slices()} plots slices of the (log-)hazard with two time
scales, at selected values of one of the two time dimensions.
}
