% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_fisher.R
\name{fisher}
\alias{fisher}
\title{Fisher's F Distribution Function}
\usage{
fisher(x = NULL, y = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional first vector (not needed for interactive mode)}

\item{y}{Optional second vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The F statistic (for non-interactive mode)
}
\description{
This function calculates the F statistic between two groups.
}
\examples{
x <- c(70,75,74,72,68,59)
y <- c(74,77,70,80,72,76)

# Simple calculation
fisher(x, y)

# Learning mode
fisher(x, y, learn = TRUE)

# Interactive mode
if(interactive()){
fisher(interactive = TRUE)
}

}
