% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimod.R
\name{test_multimod}
\alias{test_multimod}
\title{Multimodality test for post clustering variable involvement}
\usage{
test_multimod(X, g, cl, k1, k2)
}
\arguments{
\item{X}{The data matrix of size on which the clustering is applied}

\item{g}{The variable on which the test is applied}

\item{cl}{The labels of the data obtained thanks to a clustering algorithm}

\item{k1}{The first cluster of interest}

\item{k2}{The second cluster of interest}
}
\value{
A list containing :  A list with the following elements \itemize{
\item \code{data_for_test} : The data used for the test
\item \code{stat_g} : The dip statistic
\item \code{pval} : The resulting p-values of the test computed with the \code{diptest} function
}
}
\description{
Multimodality test for post clustering variable involvement
}
\examples{
X <- matrix(rnorm(200),ncol = 2)
hcl_fun <- function(x){
return(as.factor(cutree(hclust(dist(x), method = "ward.D2"), k=2)))}
cl <- hcl_fun(X)
plot(X, col=cl)
test_var1 <- test_multimod(X, g=1, k1=1, k2=2, cl = cl)
test_var2 <- test_multimod(X, g=2, k1=1, k2=2, cl = cl)
}
