% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_model}
\alias{get_model}
\title{Select the Best Fitting Model.}
\usage{
get_model(object, model.no = NULL, cpx = NULL)
}
\arguments{
\item{object}{(object) of class "VFP"}

\item{model.no}{(integer) specifying a fitted model stored in 'object'}

\item{cpx}{(integer) vector specifying the order of complexity
   used to select the less complex model when multiple, 
identical AIC values occur, taken from the fitted object
   or c(1, 2, 3, 9, 5, 4, 7, 6, 8) is used if not specified}
}
\value{
(integer) index of selected model in 'object$Models' or 'object$AIC'
}
\description{
In case the user has not specified a specific model out of multiple fitted
models the one with the lowes AIC value will be selected. If multiple models
have the same AIC the one with the lowes complexity will be chosen.
}
\examples{
\donttest{
library(VCA)
data(VCAdata1)
lst <- anovaVCA(y~(device+lot)/day/run, VCAdata1, by="sample")
mat <- get_mat(lst)		# automatically selects "total"
res <- fit_vfp(model.no=1:9, Data=mat)
get_model(res)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
