% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSampleDataBin.R
\name{generateSampleDataBin}
\alias{generateSampleDataBin}
\title{generateSampleDataBin}
\usage{
generateSampleDataBin(n, K, w, p, Irrp, yout = FALSE)
}
\arguments{
\item{n}{Number of observations in dataset.}

\item{K}{Number of clusters desired.}

\item{w}{A vector of mixture weights (proportion of population in each
cluster).}

\item{p}{Number of clustering variables/covariates in dataset.}

\item{Irrp}{Number of irrelevant/noisy variables/covariates in dataset. Note
that these variables will be the final Irrp columns in the simulated
dataset. Total data dimension is p + Irrp.}

\item{yout}{Default FALSE. Indicate whether a binary outcome associated with
clustering is required.}
}
\value{
A list with the following components: 
  \item{data}{A matrix consisting of the simulated data.} 
  \item{trueClusters}{A vector with the simulated cluster assignments.}
  \item{outcome}{If yout = TRUE, this will be a vector with the outcome
  variable.}
}
\description{
Generate sample clustered binary data with cluster labels. The probability of
a '1' in each cluster for each variable is randomly generated via a Beta(1,
5) distribution, encouraging sparse probabilities which vary across clusters.
For noisy variables, the probability of a '1' is also generated by a Beta(1,
5) distribution but this probability is the same regardless of the cluster
membership of the observation.
}
\examples{
# example code
generatedData <- generateSampleDataBin(1000, 4, c(0.1, 0.2, 0.3, 0.4), 100, 0)

}
