% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{make_vt_data}
\alias{make_vt_data}
\title{Make custom visual testing data}
\usage{
make_vt_data(
  estimates,
  variances = NULL,
  type = c("est_var", "sim"),
  tol = 1e-08,
  ...
)
}
\arguments{
\item{estimates}{A vector of estimates if type is \code{"est_var"} and or a number of simulations by
number of parameters matrix of simulated values if type is \code{"sim"}.}

\item{variances}{In the case of independent estimates, a vector of variances of the same length
as \code{estimates} if type is \code{"est_var"}.  These will be used as the diagonal elements in a variance-covariance matrix with
zero covariances.  Alternatively, if type is \code{"est_var"}, this could be a variance-covariance matrix, with the same number
of rows and columns as there are elements in the \code{estimates} vector.  If type is \code{"sim"}, variances should be \code{NULL}, but
will be disregarded in any event. Also, note, these should be variances of the estimates (e.g., squared standard errors) and not
raw variances from the data.}

\item{type}{Indicates the type of input data either estimates with variances or a variance-covariance matrix or data from
a simulation.}

\item{tol}{Tolerance for evaluation of symmetry and positive definiteness.}

\item{...}{Other arguments passed down, currently not implemented.}
}
\value{
\enumerate{
\item If the input is a vector of parameter estimates and a variance-covariance matrix, then a list with estimates and a variance-covariance matrix of class \code{"vtcustom"} is returned.  In this case, the functionms \code{coef.vtcustom()} and \code{vcov.vtcustom()} are
used to extract the coefficients and variance-covariance matrix in a way that will work with \code{viztest.default()}.
\item If the input is a matrix of simulation draws, an object of class \code{"vtsim"} that has a single element - the data giving the draws from the simulation is returned.  In this case, \code{viztest.vtsim()} does the relevant testing.
}
}
\description{
Makes custom visual testing objects that can be used as input to the \code{viztest()} function.  This is useful in the case
where \code{coef()} and \code{vcov()} do not function as expected on objects of interest, where the user wants to intervene with some
modification to the usual estimates or (more likely) variance-covariance matrix or where normal theory tests may not be
as useful (e.g., in the case of simulations of non-normal values).  The examples section below shows how this could be leveraged
to use a heteroskedasticity-consistent covariance matrix in the test rather than the one returned by \code{lm()}.
}
\examples{
data(mtcars)
mtcars$cyl <- as.factor(mtcars$cyl)
mtcars$hp <- scale(mtcars$hp)
mtcars$wt <- scale(mtcars$wt)
mod <- lm(qsec ~ hp + wt + cyl, data=mtcars)
V <- sandwich::vcovHC(mod, "HC3")
vtdat <- make_vt_data(coef(mod), V)
viztest(vtdat, 
        test_level = .025, 
        include_intercept = FALSE, 
        include_zero = FALSE)
}
