% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPeak.R
\name{findPeak}
\alias{findPeak}
\title{Find peaks using the estimated values}
\usage{
findPeak(k, filter, select)
}
\arguments{
\item{k}{Output of the `kdeC` function, containing estimated values.}

\item{filter}{A numeric value used to filter out results with estimated values less than the given `filter` argument.}

\item{select}{A numeric value specifying the number of peaks to retain, selecting the K peaks with the largest estimated values.}
}
\value{
A three-column matrix (`markMat`) where:
  - Column 1: x-coordinates of the peaks
  - Column 2: y-coordinates of the peaks
  - Column 3: Corresponding estimated values of the peaks.
}
\description{
Find peaks using the estimated values
}
\examples{
data(r)
k <- kdeC(r$dat, H = c(0.014, 0.014), gridsize = c(330, 330), cutNum = c(1, 1), w = r$z)
m <- findPeak(k, filter = 0, select = 100)
}
