% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeOptimalPrice}
\alias{computeOptimalPrice}
\title{Computes the profit-maximizing price}
\usage{
computeOptimalPrice(campaign)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}
}
\value{
Profit-maximizing price in [0; 1] where 0 is the lowest possible and 1 is the highest possible price.
}
\description{
Computes the profit-maximizing for a given Word-of-Mouth campaign.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
price <- computeOptimalPrice(campaign)
profit <- computeProfit(campaign, price)
print(price)
print(profit)

}
\seealso{
\code{\link{computeDemand}} \code{\link{computeProfit}} \code{\link{computeConsumerSurplus}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
