% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeWoMIntensity}
\alias{computeWoMIntensity}
\title{Computes the WoM intensity}
\usage{
computeWoMIntensity(campaign)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}
}
\value{
WoM intensity in [0; 1].
}
\description{
Computes the WoM intensity in a given Word-of-Mouth campaign.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
intensity <- computeWoMIntensity(campaign)
print(intensity)

}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
