% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_rmds.R
\name{retrieve_rmds}
\alias{retrieve_rmds}
\title{Find Rmd files within a provided file structure.}
\usage{
retrieve_rmds(search_dir = ".", recurse = TRUE, to_txt = FALSE)
}
\arguments{
\item{search_dir}{The directory to search. Defaults to ".".}

\item{recurse}{Defaults to TRUE. Should child directories be searched or
not.}

\item{to_txt}{Defaults to FALSE. If TRUE, writes found rmd paths in a txt to
the \code{search_dir}.}
}
\value{
Relative paths to all found Rmd files.
}
\description{
Recursively searches file structure for Rmarkdown files. Returns the found
Rmd relative paths.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# Create a test directory
dir.create("parent")
dir.create("parent/child")

# Create some rmds to find
# An empty vector to collect file names
nm_vec <- character()
# create numbered file names
for (num in 1:6) {
  nm <- paste0(num, "-test.Rmd")
  nm_vec <- append(nm_vec, nm)
}
# Create some files in parent & child directories
file.create(paste0("parent/", nm_vec[1:3]))
file.create(paste0("parent/child/", nm_vec[4:6]))

# Return all Rmd files
retrieve_rmds("parent")

# tidy up environment
unlink(c("parent", "child"), recursive = TRUE)
\dontshow{
setwd(.old_wd)
}

}
