% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs_plot.R
\name{aclhs.plot_params}
\alias{aclhs.plot_params}
\title{Set parameters for plotting.}
\usage{
aclhs.plot_params(
  file_name,
  plot_title = "",
  xlab = "",
  ylab = "",
  width = 1000,
  height = 1000,
  res = 150,
  legend = NULL
)
}
\arguments{
\item{file_name}{The name of the file to store the plot in (should end with '.png')}

\item{plot_title}{The title of the plot (default is blank)}

\item{xlab}{The label for the x axis of the plot (default is blank)}

\item{ylab}{The label for the y axis of the plot (default is blank)}

\item{width}{The width of the plot (default is 1000)}

\item{height}{The height of the plot (default is 1000)}

\item{res}{The resolution of the plot (default is 150)}

\item{legend}{The location of the legend on the plot (default is NULL)}
}
\value{
A list of the set plotting parameters
}
\description{
Sets various parameters for plotting including plot title, axis labels,
plot dimensions and resolution, and whether to add a legend to the plot.
By default, a plot will not be created, and the location of where the
legend should be placed on the plot should be passed (e.g., "topright").
}
\examples{
## Set the parameters
p_params <- aclhs.plot_params(file_name=tempfile(fileext=".png"),
                              plot_title=expression(bold("Sample Distribution")),
                              xlab=expression(bold("X [km]")),
                              ylab=expression(bold("Y [km]")),
                              legend="topright")

## Access one of the the set parameters
p_params$plot_title
}
