% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_opt.R
\name{cov_mat}
\alias{cov_mat}
\title{Estimates covariance matrices used by Gaussian process optimisation}
\usage{
cov_mat(x1, x2 = x1, g = NULL, pow = 2, lengthscale = 1)
}
\arguments{
\item{x1}{numeric vector, with length corresponding to the number of rows in
the returned matrix.}

\item{x2}{numeric vector, with length corresponding to the number of columns
in the returned matrix. If not specified, \code{x1} will be used for \code{x2}.}

\item{g}{single numerical value; jitter/nugget value added to the diagonal
if not \code{NULL} (the default); should be supplied if \code{x1} is the same as
\code{x2}, to avoid potentially negative values in the matrix diagonal due to
numerical instability.}

\item{pow}{single numeric value, the power that all distances are raised to.
Defaults to \code{2}, corresponding to pairwise, squared, Euclidean distances.}

\item{lengthscale}{single numerical value; lengthscale hyperparameter that
the matrix returned from \code{\link[=pow_abs_dist]{pow_abs_dist()}} is divided by before the inverse
exponentiation is done.}
}
\value{
Covariance matrix with \code{length(x1)} rows and \code{length(x2)} columns
used by the Gaussian process optimiser.
}
\description{
Used internally, estimates covariance matrices used by the Gaussian process
optimisation function. Calculates pairwise absolute distances raised to a
power (which defaults to \code{2}) using the \code{\link[=pow_abs_dist]{pow_abs_dist()}} function, divides
the result by a\code{ lengthscale} hyperparameter (which defaults to \code{1}, i.e., no
changes due to division), and subsequently returns the inverse exponentiation
of the resulting matrix.
}
\keyword{internal}
