% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xml_request.R
\name{buildXmlBody}
\alias{buildXmlBody}
\title{Build XML Body}
\usage{
buildXmlBody(adwordsService, ManagedCustomerService_Selector_fields = NULL,
  categoryProductsAndServices = NULL, competition = NULL,
  ideaTextFilter_included = NULL, ideaTextFilter_excluded = NULL,
  includeAdultContent = NULL, language = NULL, location = NULL,
  network_GoogleSearch = NULL, network_SearchNetwork = NULL,
  relatedToQuery = NULL, relatedToUrl = NULL, searchVolumeMinimum = NULL,
  searchVolumeMaximum = NULL, seedAdGroupId = NULL, requestType = NULL,
  attributeTypes = NULL, pagingStartIndex = NULL,
  pagingNumberResults = NULL, apiVersion)
}
\arguments{
\item{adwordsService}{The chosen Adwords Service for the request}

\item{ManagedCustomerService_Selector_fields}{The requested fields from the ManagedCustomerService, such as CustomerId.}

\item{categoryProductsAndServices}{A keyword category ID (Integer) in the "Products and Services" taxonomy that all search results should belong to.}

\item{competition}{Vector of Levels of competition that should be included in the results}

\item{ideaTextFilter_included}{The vector of strings that should be included}

\item{ideaTextFilter_excluded}{The vector of strings that should be excluded}

\item{includeAdultContent}{TRUE or FALSE option for including the targeting of Adult Content.}

\item{language}{The Language (or Criterion ID) that all results should be targeted against.}

\item{location}{The Location (or Criterion ID) that all results should be targeted against.}

\item{network_GoogleSearch}{Whether search should be targeting Google Search}

\item{network_SearchNetwork}{Whether search should be targeting the Google Search Network (AFS)}

\item{relatedToQuery}{The vector of queries to post to the API as a Search Parameter.}

\item{relatedToUrl}{The vector of URLs to post to the API, which results will be related to.}

\item{searchVolumeMinimum}{The minimum Search Volume that should be targeted.}

\item{searchVolumeMaximum}{The maximum Search Volume that should be targeted.}

\item{seedAdGroupId}{The Adgroup ID that should be used as a seed for generating new ideas.}

\item{requestType}{Represents the type of the request.}

\item{attributeTypes}{Vector of Attributes Types.}

\item{pagingStartIndex}{Index of the first result to return. (Optional)}

\item{pagingNumberResults}{Maximum number of results to return. This figure is limited to 700. (Optional)}

\item{apiVersion}{Version of the API being used.}
}
\value{
Returns the XML Body for the Envelope
}
\description{
Build the XML Body for the XML Envelope.
}
\examples{
buildXmlBody("ManagedCustomerService", 
             c("Name", "CustomerId"), 
             apiVersion = "v201806")
}
