% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Descriptive.R
\name{show.correlations}
\alias{show.correlations}
\title{Print correlations of matching factors with matching and outcome variables}
\usage{
show.correlations(
  res,
  Z = matrix(0, nrow = N, ncol = 0),
  labels_x = paste0("Trait ", 1:Kx),
  labels_y = paste0("Trait ", 1:Ky),
  labels_z = if (Kz > 0) paste0("Outcome ", 1:Kz) else c(),
  ndims = min(Kx, Ky, 10),
  pr = 0.02,
  color_arrows = c("black", "red"),
  size_arrows = 0.5,
  font_labels = c("bold", "italic"),
  label_x_axis = "First partner",
  label_y_axis = "Second partner"
)
}
\arguments{
\item{res}{A list corresponding to the output of
\code{\link{estimate.affinity.matrix}},
\code{\link{estimate.affinity.matrix.lowrank}} or
\code{\link{estimate.affinity.matrix.unipartite}}.}

\item{Z}{A matrix Z with additional variables that were not previously used
in the estimation. The i-th row of \code{Z} must contain information on
the couple formed by the i-th row of \code{X} and the i-th row of
\code{Y}, so that \code{nrow(Z)=nrow(X)}. Defaults to an empty matrix:
\code{Z} is optional.}

\item{labels_x}{A vector of strings indicating the names of men's matching
variables. Defaults to \code{"Trait k"} for every \code{k} matching
variable.}

\item{labels_y}{A vector of strings indicating the names of women's matching
variables. Defaults to \code{"Trait k"} for every \code{k} matching
variable.}

\item{labels_z}{A vector of strings indicating the names of the outcome
variables. Defaults to \code{"Outcome k"} for every \code{k} outcome variable.}

\item{ndims}{An integer indicating the number of orthogonal matching
dimensions that will be plotted. The function plots the first \
code{ndims} dimensions. Defaults to all dimensions unless the latter are
more than 10, in which case only the first 10 are plotted.}

\item{pr}{A probability indicating the two-tailed significance level required
for a matching or outcome variable to be displayed in a plot. In order to
avoid having too many variables plotted at the same time, the function
only selects those whose correlation with the matching factor is
significantly different from zero (in a two-tailed test) at the \code{pr}
level. Defaults to 0.02 and can be set to 1 to print all variables.}

\item{color_arrows}{A string or a vector of strings containing color names
for the arrows. All matching variables are assigned the first color given
in the vector, while all outcome variables are assigned the second color.
See \code{\link[ggplot2]{ggplot}}. Defaults to \code{"black"} and
\code{"red"} respectively.}

\item{size_arrows}{A positive real number or a vector containing the size of
the arrows. All matching variables are assigned the first size given in
the vector, while all outcome variables are assigned the second size. See
\code{\link[ggplot2]{ggplot}}. Defaults to 0.5 for both.}

\item{font_labels}{A string or a vector of strings containing font types for
the labels. All matching variables are assigned the first font type given
in the vector, while all outcome variables are assigned the second font
type. See \code{\link[ggplot2]{ggplot}}. Defaults to \code{"bold"} and
\code{"italic"} respectively.}

\item{label_x_axis}{A string containing a root for all x-axis names in
different plots. Defaults to \code{"First partner"}.}

\item{label_y_axis}{A string containing a root for all y-axis names in
different plots. Defaults to \code{"Second partner"}.}
}
\value{
The function returns a list of \code{ndims} plots created with
\code{\link[ggplot2]{ggplot}}.
}
\description{
This function returns a list of plots, one for each of the first \code{ndims}
orthogonal sorting dimension. In the k-th plot, the correlation between a
man's observed matching variable and the man's k-th matching factor is
plotted on the x-axis; the correlation between a woman's observed matching
variable and the woman's k-th matching factor is plotted on the y-axis. In
addition, the user can supply additional variables stored in the matrix
\code{Z} that were not previously used in the estimation ("outcome
variables"). The function prints the correlation between the outcome variable
and the man's k-th matching factor on the x-axis, while the correlation
between the outcome variable and the woman's k-th matching factor is on the
y-axis.
}
\seealso{
\strong{Chiappori, Pierre-Andre, Edoardo Ciscato, and Carla
Guerriero}. "Analyzing matching patterns in marriage: theory and
application to Italian data." \emph{HCEO Working Paper} no. 2020-080
(2020).
}
