% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{subtree}
\alias{subtree}
\title{Subtree}
\usage{
subtree(tree, leaves = NULL, cv = FALSE)
}
\arguments{
\item{tree}{An \code{\link[rpart]{rpart}} object.}

\item{leaves}{Number of leaves of the desired subtree.}

\item{cv}{If \code{TRUE}, \code{leaves} is ignored and a cross-validation criterion is used to select a partition.}
}
\value{
The subtree, as an \code{\link[rpart]{rpart}} object.
}
\description{
Extracts a subtree with a user-specified number of leaves from an \code{\link[rpart]{rpart}} object.
}
\examples{
## Generate data.
set.seed(1986)

n <- 3000
k <- 3

X <- matrix(rnorm(n * k), ncol = k)
colnames(X) <- paste0("x", seq_len(k))

Y <- exp(X[, 1]) + 2 * X[, 2] * X[, 2] > 0 + rnorm(n)

## Construct tree.
library(rpart)
tree <- rpart(Y ~ ., data = data.frame(Y, X), cp = 0)

## Extract subtree.
sub_tree <- subtree(tree, leaves = 4)
sub_tree_cv <- subtree(tree, cv = TRUE)

}
\seealso{
\code{\link{get_leaves}} \code{\link{node_membership}} \code{\link{leaf_membership}}
}
\author{
Riccardo Di Francesco
}
