# Generated by pointblank
library(pointblank)

tbl <- confidence_score_evaluation(confidence_scores = data_confidence_scores,
                                   outcomes = data_outcomes)

test_that("column `method` exists", {

  expect_col_exists(
    tbl,
    columns = vars(method),
    threshold = 1
  )
})

test_that("column `AUC` exists", {

  expect_col_exists(
    tbl,
    columns = vars(AUC),
    threshold = 1
  )
})

test_that("column `Brier_Score` exists", {

  expect_col_exists(
    tbl,
    columns = vars(Brier_Score),
    threshold = 1
  )
})

test_that("column `Classification_Accuracy` exists", {

  expect_col_exists(
    tbl,
    columns = vars(Classification_Accuracy),
    threshold = 1
  )
})

test_that("column `AUC` is of type: numeric", {

  expect_col_is_numeric(
    tbl,
    columns = vars(AUC),
    threshold = 1
  )
})

test_that("column `Brier_Score` is of type: numeric", {

  expect_col_is_numeric(
    tbl,
    columns = vars(Brier_Score),
    threshold = 1
  )
})

test_that("column `Classification_Accuracy` is of type: numeric", {

  expect_col_is_numeric(
    tbl,
    columns = vars(Classification_Accuracy),
    threshold = 1
  )
})

test_that("column `method` is of type: character", {

  expect_col_is_character(
    tbl,
    columns = vars(method),
    threshold = 1
  )
})

test_that("values in `AUC` should be between `0` and `1`", {

  expect_col_vals_between(
    tbl,
    columns = vars(AUC),
    left = 0,
    right = 1,
    threshold = 1
  )
})

test_that("all values in `method` should not be NULL", {

  expect_col_vals_not_null(
    tbl,
    columns = vars(method),
    threshold = 1
  )
})

test_that("all values in `AUC` should not be NULL", {

  expect_col_vals_not_null(
    tbl,
    columns = vars(AUC),
    threshold = 1
  )
})

test_that("all values in `Brier_Score` should not be NULL", {

  expect_col_vals_not_null(
    tbl,
    columns = vars(Brier_Score),
    threshold = 1
  )
})

test_that("all values in `Classification_Accuracy` should not be NULL", {

  expect_col_vals_not_null(
    tbl,
    columns = vars(Classification_Accuracy),
    threshold = 1
  )
})

test_that("values in `method` should be in the set of `ArMean`, `Median`, `LOArMean` (and 36 more)", {

  expect_col_vals_in_set(
    tbl,
    columns = vars(method),
    set = c("ArMean", "Median", "LOArMean", "BetaArMean",
            "IndIntAsymWAgg", "ShiftWAgg", "ReasonWAgg", "QuizWAgg",
            "BayTriVar", "BayPRIORsAgg", "IntWAgg", "IndIntWAgg",
            "VarIndIntWAgg", "AsymWAgg", "KitchSinkWAgg", "OutWAgg",
            "DistLimitWAgg", "GranWAgg", "DistribArMean", "CompWAgg",
            "ReasonWAgg2", "EngWAgg", "LOGeoMean", "ProbitArMean",
            "BestShiftWAgg", "TriDistribArMean", "GeoMean", "BetaArMean2",
            "BetaReasonWAgg", "BetaReasonWAgg2", "BadgeWAgg", "ExperienceWAgg",
            "ExperienceWAgg2", "ExperienceWAgg3", "QuizWAgg2", "QuizWAgg3",
            "DistShiftWAgg", "IntShiftWAgg", "DistIntShiftWAgg"),
    threshold = 1
  )
})
