% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.mart.R
\name{stability.mart}
\alias{stability.mart}
\title{Weighted homeostaticity index}
\usage{
stability.mart(dataf, res_var, gen_var, env_var, rep_var, alpha = 0.05,
  plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{alpha}{alpha level of LSD; default is 0.05.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
A numeric vector with weighted homeostaticity index of genotypes.
}
\description{
This function calculates the Martynov's weighted homeostaticity index.
}
\examples{
data(exp_data)
stability.mart(exp_data,"yield","gen","env","rep")
}
\references{
Martynov S.P. 1990. A Method for the Estimation of Crop Varieties Stability. Biom. J. 7: 887-893.
}
