% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_increased_doses.R
\name{assess_increased_doses}
\alias{assess_increased_doses}
\title{Analyze physicians' compliance to dosing guidelines: INCREASE DOSE}
\usage{
assess_increased_doses(
  input_files_path,
  anc_threshold = NA,
  plt_threshold = NA,
  hb_threshold = NA,
  escalation_factor,
  tolerated_dose_duration
)
}
\arguments{
\item{input_files_path}{path to a file or a folder with MT csv files (in quotes).}

\item{anc_threshold}{Absolute neutrophil count (ANC) value threshold above which doses should be increased. NOTE: Ensure that the threshold value is represented with same unit as of the input ANC data.}

\item{plt_threshold}{Platelet (PLT) value threshold above which doses should be increased. NOTE: Ensure that the threshold value is represented with same unit as of the input PLT data.}

\item{hb_threshold}{Hemoglobin (HB) value threshold below which doses should be increased. NOTE: Ensure that the threshold value is represented with same unit as of the input Hb data.}

\item{escalation_factor}{Percentage of increase from previous tolerated dose to be considered as "increased" dose.}

\item{tolerated_dose_duration}{Number of weeks with ANC, PLT, and Hb values consistently above threshold with same dose prescription,
following which dose should be increased.}
}
\value{
Returns a list with (1) the 'INCREASE DOSE' analysis for each patient as listed below,
(2) analysis summary as dataframe (3) analysis summary as HTML table in viewer.
\enumerate{
\item{Pat ID}
\item{Number of decisions where the physician increased dose (a)}
\item{Number of times blood counts did not support dose suspension (b)}
\item{Discordance (\%) = (\eqn{1 - (b/a)*100)}}}
}
\description{
Evaluate number of times blood counts did not support physicians' INCREASE DOSE decision
}
\note{
\enumerate{
\item{Atleast one of the threshold parameters (anc_threshold, plt_threshold, hb_threshold) must be provided to carry out analysis. Missing threshold parameter will not be considered.}
\item{If the function is used for cohort analysis then a and b will be represented as median and interquartile range (IQR) (25\%-75\%). The median and IQR is rounded off to upper integer value if decimal value is greater or equal to 0.5, else to lower integer value Example 1.4->1 and 3.75->4}
\item{User may save the result as a list, if required, to analyze each patient separately - use 1st element of list. Please refer to examples from \link[allMT]{assess_anemia}}
}
}
\examples{

cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
assess_increased_doses(input_files_path = cohort_path, anc_threshold = 0.75,
                      plt_threshold = 75, hb_threshold = 8,
                      escalation_factor = 25, tolerated_dose_duration = 8)
\donttest{

pat_data = system.file("extdata/processed_data/", "UPN_914.csv", package = "allMT")
assess_increased_doses (input_files_path = pat_data, anc_threshold = 0.75,
                      plt_threshold = 75, hb_threshold = 8,
                      escalation_factor = 15, tolerated_dose_duration = 6)

assess_increased_doses(input_files_path = cohort_path,
                      anc_threshold = 0.7, plt_threshold = 60)
}


}
\seealso{
\code{\link[=time_to_first_dose_increase]{time_to_first_dose_increase()}}, \code{\link[=assess_reduced_doses]{assess_reduced_doses()}}, \code{\link[=assess_stop_doses]{assess_stop_doses()}}
}
