% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_plot.R
\name{all_plot}
\alias{all_plot}
\title{Plot all effect estimates against p values}
\usage{
all_plot(
  data,
  xlabels = c(0, 0.001, 0.01, 0.05, 0.2, 0.5, 1),
  xlim = c(0, 1),
  xlab = "P value",
  ylim = NULL,
  ylab = NULL,
  yscale_log = FALSE,
  title = NULL
)
}
\arguments{
\item{data}{\emph{Object} from \code{all_cox}, \code{all_glm}, \code{all_speedglm}, or \code{all_glm}, including all effect estimate values.}

\item{xlabels}{\emph{Numeric vector} x-axis tick labels. Default is
\code{"c(0, 0.001, 0.01, 0.05, 0.2, 0.5, 1)"}.}

\item{xlim}{\emph{Vector} of 2 numeric values for x-axis limits. Default is \code{"c(0, 1)"}.}

\item{xlab}{\emph{Character} string for x-axis name. Default is \code{"P value"}.}

\item{ylim}{\emph{Vector} of 2 numeric values for y-axis limits.}

\item{ylab}{\emph{Character} string for y-axis name. Default depends on original model types.}

\item{yscale_log}{\emph{TRUE or FALSE} to re-scale y-axis to "log10". Default is \code{"FALSE"}.}

\item{title}{\emph{Character} for plot title. Default is \code{"NULL"}.}
}
\value{
A \pkg{ggplot2} object: scatter plot
}
\description{
\code{all_plot()}  generates a scatter plot with effect estimates of all possible models
again p values.
}
\examples{
vlist <- c("Age", "Sex", "Married", "BMI", "Education", "Income")
results <- all_cox(crude = "Surv(t0, t1, Endpoint) ~ Diabetes", xlist = vlist, data = diab_df)
all_plot(results)
}
