% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{compare_target_numeric}
\alias{compare_target_numeric}
\title{Comparison of numerical variables of train set and test set}
\usage{
compare_target_numeric(.data, ...)
}
\arguments{
\item{.data}{an object of class "split_df", usually, a result of a call to split_df().}

\item{...}{one or more unquoted expressions separated by commas.
Select the numeric variable you want to compare.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, compare_target_numeric() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}
}
\value{
tbl_df.
Variables for comparison:
\itemize{
\item variable : character. numeric variable name
\item train_mean : numeric. arithmetic mean of train set
\item test_mean : numeric. arithmetic mean of test set
\item train_sd : numeric. standard deviation of train set
\item test_sd : numeric. standard deviation of test set
\item train_z : numeric. the arithmetic mean of the train set divided by
the standard deviation
\item test_z : numeric. the arithmetic mean of the test set divided by
the standard deviation
}
}
\description{
Compare the statistics of the numerical variables of
the train set and test set included in the "split_df" class.
}
\details{
Compare the statistics of the numerical variables of the train set and
the test set to determine whether the raw data is well separated into two data sets.
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb \%>\%
  compare_target_numeric()

sb \%>\%
  compare_target_numeric(balance)

}
