% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altfuel_api.R
\name{altfuel_api}
\alias{altfuel_api}
\title{Query the NREL Alternative Fuel API}
\usage{
altfuel_api(api_key, endpoint, params = list(NULL))
}
\arguments{
\item{api_key}{Character. An authorized API key for the NREL API service. API keys can be requested at \url{https://developer.nrel.gov/signup/}}

\item{endpoint}{Character. Path to the specific API endpoint. Options available at \url{https://developer.nrel.gov/docs/transportation/alt-fuel-stations-v1/}}

\item{params}{A list of parameters for the API call. See ?nrel_params for options.}
}
\value{
An object of class nrel_api, containing content, parameters, and response.
}
\description{
Query the NREL Alternative Fuel API
}
\examples{
\dontrun{
altfuel_api(MY_API_KEY, endpoint = "/api/alt-fuel-stations/v1")
}
}
