% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altfuel_api.R
\name{nrel_params}
\alias{nrel_params}
\title{Configure parameters for NREL API call}
\usage{
nrel_params(
  status = NULL,
  access = NULL,
  fuel_type = NULL,
  cards_accepted = NULL,
  owner_type = NULL,
  federal_agency = NULL,
  cng_fill_type = NULL,
  cng_psi = NULL,
  cng_vehicle_class = NULL,
  e85_has_blender_pump = NULL,
  ev_network = NULL,
  ev_charging_level = NULL,
  ev_connector_type = NULL,
  ev_connector_type_operator = NULL,
  lng_vehicle_class = NULL,
  state = NULL,
  zip = NULL,
  country = NULL,
  limit = NULL,
  location = NULL,
  latitude = NULL,
  longitude = NULL,
  radius = NULL
)
}
\arguments{
\item{status}{Return stations that match the given status. A single status, or a comma-separated list of multiple statuses, may be given. Options: all, E (Available), P (Planned), T (Temporarily unavailable).}

\item{access}{Return stations with the given access type. Options: all, public, private.}

\item{fuel_type}{Return stations that supply any of the given fuel types. A single fuel type, or a comma-separated list of multiple fuel types, may be given. Options: all, BD (biodiesel), CNG (compressed natural gas), ELEC (electric), E85 (ethanol/E85), HY (hydrogen), LNG (liquified natural gas), LPG, (propane).}

\item{cards_accepted}{Return stations that accept any of the given payment methods. A single payment method, or a comma-separated list of multiple payment methods, may be given.  Options: all, A, Debit, D, M, V, Cash, Checks, ALLIANCE, ARI, CleanEnergy, Comdata, CFN, EFS, FleetOne, FuelMan, GasCard, PacificPride, PHH, Proprietor, Speedway, SuperPass, TCH, Tchek, Trillium, Voyager, Wright_Exp.}

\item{owner_type}{Return stations owned by the given types of owners. A single owner type, or a comma-separated list of multiple owner types, may be given.  Options: all, FG (Federal Govt Owned), J (Joint Owned), LG (Local/Municipal Govt Owned), P (Privately Owned), SG (State/Provincial Govt Owned), T (Utility Owned).}

\item{federal_agency}{Return stations owned by the given federal agency. A federal agency code, or a comma-separated list of multiple federal agency codes, may be given.  Options: all, AAF, CH, CHSW, USACE_CW, CSOSA, DEF, DAF, DA, DOC, HHS, DHS, HUD, DOJ, DOL, DON, DOS, DOI, DOT, DTS, VA, EWDL, ECC, FCSD, FTC, FIN, FOCCG, GSA, GAFA, GAID, GAIT, HLTH, IRC, INA, IC, ISED, JUS, LGHC, NASA, NDEF, NREV, NRES, PARL, PQPCC, PM, PSEP, PSP, SCI, SBT, SI, SSA, TRANS, TREAS, USMC, CBP, USDA, DOD, DOE, EPA, FAA, IRS, USPS, VAFF.}

\item{cng_fill_type}{Return only CNG stations that provide the specified type of dispensing capability. A single type, or a comma separated list of multiple types, may be given.  Options: all, B (Fast-fill and time-fill), Q (Fast-fill), T (Time-fill).}

\item{cng_psi}{Return only CNG stations that provide the specified PSI pressure. A single pressure level, or a comma separated list of multiple pressure levels, may be given.  Options: all, 2400, 3000, 3600.}

\item{cng_vehicle_class}{Return only CNG stations that can accommodate the specified vehicle class size or greater.  Options: all, LD, MD, HD.}

\item{e85_has_blender_pump}{Logical. If TRUE, then return only E85 stations that also have a blender pump capable of providing mid-level ethanol blends.}

\item{ev_network}{Return only electric charging stations that belong to the given network. A single network, or a comma separated list of multiple networks, may be given.  Options: all, BCHYDRO, Blink Network, ChargePoint Network, Circuit électrique, eCharge Network, Electrify America, Electrify Canada, EV Connect, EVGATEWAY, eVgo Network, FLO, FCN, GE WattStation, Greenlots, Non-Networked, OpConnect, PETROCAN, POWERFLEX, SemaCharge Network, Sun Country Highway, SWTCH, Tesla Destination, Tesla, Volta, Webasto.}

\item{ev_charging_level}{Return only electric charging stations that provide the given level of electric vehicle supply equipment (EVSE).  Options: all, 1, 2, dc_fast, legacy.}

\item{ev_connector_type}{Return only electric charging stations that provide the given connector types.  Options: all, NEMA1450, NEMA515, NEMA520, J1772, J1772COMBO, CHADEMO, TESLA.}

\item{ev_connector_type_operator}{Control how multiple connector type options passed to the ev_connector_type parameter behave. The default of OR will return stations that have any of the connectors present. Specifying AND will only return stations that have all of the connectors present.}

\item{lng_vehicle_class}{Return only LNG stations that can accommodate the specified vehicle class size or greater.  Options: all, LD, MD, HD.}

\item{state}{Return only stations within the given state. State must be given as a two character state code (eg, "CO" for Colorado). A single state, or a comma-separate list of multiple states, may be given.}

\item{zip}{Return only stations within the given ZIP code. ZIP codes must be exactly 5 digits long. A single ZIP code, or a comma-separate list of multiple ZIP codes, may be given.}

\item{country}{Return only stations within the given country code.  Options: all, US (United States), CA (Canada).}

\item{limit}{The maximum number of results to return. An explicit limit of up to 200 may be passed in, or the special all string may be passed in to return all results.}

\item{location}{A free-form input describing the address of the location. This may include the address given in a variety of formats, such as: street, city, state, postal code, etc.}

\item{latitude}{Numeric. The latitude of the desired location.}

\item{longitude}{Numeric. The longitude of the desired location.}

\item{radius}{Numeric. The radius (in miles) around the search location to search for stations within. An explicit radius of up to 500.0 miles may be passed in, or the special infinite string may be passed in to find the nearest stations regardless of distance.}
}
\value{
A list of selected options for passing to an api call.
}
\description{
Configure parameters for NREL API call
}
\examples{
# Which electric charging stations have Tesla connectors?
my_params <- nrel_params(fuel_type = "ELEC", ev_connector_type = "TESLA")
}
