% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{c4est}
\alias{c4est}
\title{Estimating the fourth cumulant of the trawl process}
\usage{
c4est(data, Delta)
}
\arguments{
\item{data}{The data set used to estimate the fourth cumulant}

\item{Delta}{The width Delta of the observation grid}
}
\value{
The function returns the estimated fourth cumulant of the Levy seed:
\eqn{\hat c_4(L')}.
}
\description{
This function estimates the fourth cumulant of the trawl process.
}
\details{
According to
Sauri and Veraart (2022), estimator based on
\eqn{X_0, X_{\Delta_n}, \ldots, X_{(n-1)\Delta_n}} is given by
\deqn{\hat c_4(L')=RQ_n/\hat a(0),}
where
\deqn{RQ_n:=\frac{1}{\sqrt{2 n\Delta_{n}}}
\sum_{k=0}^{n-2}(X_{(k+1)\Delta_n}-X_{k\Delta_n})^4,}
and
\deqn{\hat a(0)=\frac{1}{2\Delta_{n}n}
\sum_{k=0}^{n-2}(X_{(k+1)\Delta_n}-X_{k\Delta_n})^{2}.}
}
\examples{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 1000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(123)
#Simulate the trawl process
Poi_data<-ambit::sim_weighted_trawl(my_n, my_delta, "Exp", my_lambda, "Poi", my_v)$path

#Estimate the fourth cumulant of the trawl process
c4est(Poi_data, my_delta)
}
