% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AmbitSimulation.R
\name{sim_weighted_trawl_gen}
\alias{sim_weighted_trawl_gen}
\title{Simulation of a weighted trawl process with generic trawl function}
\usage{
sim_weighted_trawl_gen(
  n,
  Delta,
  trawlfct_gen,
  distr,
  distr_par,
  kernelfct = NULL
)
}
\arguments{
\item{n}{number of grid points to be simulated (excluding the starting value)}

\item{Delta}{grid-width}

\item{trawlfct_gen}{the trawl function a used in the simulation}

\item{distr}{marginal distribution. Choose from "Gamma" (Gamma),
"Gauss" (Gaussian), "Cauchy"
(Cauchy), "NIG" (Normal Inverse Gaussian),
Poi" (Poisson), "NegBin" (Negative Binomial)}

\item{distr_par}{parameters of the marginal distribution:
(Gamma: shape, scale;
Gauss: mu, sigma (i.e. the second parameter is the standard deviation, not the
variance);
Cauchy: l, s;
NIG: alpha, beta, delta, mu;
Poi: v, NegBin: m, theta)}

\item{kernelfct}{the kernel function p used in the ambit process}
}
\value{
path Simulated  path

slice_sizes slice sizes used

S_matrix Matrix of all slices

kernelweights kernel weights used
}
\description{
This function simulates a weighted trawl process for a generic trawl
function and various
choices the marginal distribution. The specific trawl function
to be used can be supplied
directly by the user.
}
\details{
This functions simulates a sample path from a weighted trawl process
given by
\deqn{	Y_t =\int_{(-\infty,t]\times (-\infty, \infty)}
p(t-s)I_{(0,a(t-s))}(x)L(dx,ds),} for \eqn{ t \ge 0},
and returns \eqn{Y_0, Y_{\Delta}, \ldots, Y_{n\Delta}}.
The user needs to ensure that trawlfct_gen is a monotonic function.
}
\examples{
\donttest{
#Simulation of a Gaussian trawl process with exponential trawl function
n<-2000
Delta<-0.1

trawlfct_par <-0.5
distr<-"Gauss"
distr_par<-c(0,1) #mean 0, std 1
set.seed(233)

a <- function(x){exp(-trawlfct_par*x)}
path <- sim_weighted_trawl_gen(n, Delta, a,
                           distr, distr_par)$path
#Plot the path
library(ggplot2)
df <- data.frame(time = seq(0,n,1), value=path)
p <- ggplot(df, aes(x=time, y=path))+
  geom_line()+
  xlab("l")+
  ylab("Trawl process")
p
}
}
