% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{skewness}
\alias{skewness}
\title{Skewness}
\usage{
skewness(x, na.rm = T)
}
\arguments{
\item{x}{a numeric vector, matrix or a data.frame}

\item{na.rm}{(logical) Should missing values be removed?}
}
\value{
returns a single value if \code{x} is a vector, otherwise a named
  vector of size \code{= ncol(x)}.
}
\description{
\code{skewness} calculates the skewness
}
\details{
This function calculates the skewness of data which is a measure of the
asymmetry of the probability distribution of a real-valued random variable
about its mean. The formula used is:
\deqn{\frac{E[(X-\mu)^{3}]}{(E[(X-\mu)^2])^\frac{3}{2}}}. This formula is the
typical definition used in many older textbooks and wikipedia
}
\examples{
# for a single vector
skewness(mtcars$mpg)

# for a dataframe
skewness(mtcars)

}
