% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fv_pcf.R
\name{fv_pcf}
\alias{fv_pcf}
\alias{is.fv_pcf}
\alias{print.fv_pcf}
\alias{summary.fv_pcf}
\title{Class fv_pcf: Function Value Table for PCFs}
\usage{
fv_pcf(df, n_sim, n_rank, correc, kernel, stoyan, bw)

is.fv_pcf(obj)

\method{print}{fv_pcf}(x, ...)

\method{summary}{fv_pcf}(object, ...)
}
\arguments{
\item{df}{A data frame with at least 2 columns named 'r' and 'g' containing
the values of the function argument (r) and the corresponding values
(g). Usually the upper 'upr' and lower 'lwr' bounds of a pointwise
critical envelope are passed along as well.}

\item{n_sim}{Integer. Number of generated simulated patterns used for
computing the envelope}

\item{n_rank}{Integer. Rank of the envelope value amongst the \code{n_sim}
simulated values. A rank of 1 means that the minimum and maximum
simulated values will be used.}

\item{correc}{String. Choice of edge correction (eg. "Ripley").}

\item{kernel}{String. Choice of smoothing kernel (eg. "epanechnikov").}

\item{stoyan}{Bandwidth coefficient used in smoothing kernel.}

\item{bw}{Bandwidth used in smoothing kernel.}

\item{x, obj, object}{an R object, preferably of class \code{fv_pcf}}

\item{...}{additional parameter}
}
\value{
An object of class \code{fv_pcf}.
}
\description{
Advanced Use Only. This low-level function creates an object of class
"fv_pcf" from raw numerical data.
}
