% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{is.transport.plan}
\alias{is.transport.plan}
\title{Check if function is a transport.plan}
\usage{
is.transport.plan(tplan)
}
\arguments{
\item{tplan}{An object of class `transport.plan`. See output of (transport_plan)[transport_plan]}
}
\value{
Logical
}
\description{
Check if function is a transport.plan
}
\examples{
set.seed(203987)
n <- 5
d <- 2
x <- matrix(rnorm(d*n), nrow=d, ncol=n)
y <- matrix(rnorm(d*n), nrow=d, ncol=n)
#get hilbert sort orders for x in backwards way
trans_plan <- transport_plan(X=x, Y=x, ground_p = 2, p = 2, 
                         observation.orientation =  "colwise", 
                         method = "hilbert")
print(is.transport.plan(trans_plan))
}
