% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciiruler.R
\name{asciiruler}
\alias{asciiruler}
\alias{default.asciiruler}
\title{Generate an ascii ruler}
\usage{
asciiruler(low = 0L, high = 50L, sparse_ticks = 5L, dense_ticks = TRUE,
  block_space = 0L, borders = FALSE, numbers_down = TRUE,
  line_break = "\\n", strict_width = FALSE)

default.asciiruler(x)
}
\arguments{
\item{low}{the range start, can be negative}

\item{high}{the range end, can be negative}

\item{sparse_ticks}{intermittent ticks appear every sparse_ticks, set to 0 to hide row}

\item{dense_ticks}{display a row of ticks at every position}

\item{block_space}{break up the ruler with a space every block_space blocks encountered, a multiple of sparse_ticks, set to 0 to disable}

\item{borders}{display borders}

\item{numbers_down}{display the ruler so the numbers are below the ticks}

\item{line_break}{the line break character(s)}

\item{strict_width}{hide numbers whose display would force the ruler to be wider than width(high-low)}

\item{x}{the asciiruler}
}
\value{
asciiruler object with the following slots:
\describe{
 \item{output}{delimited ruler string ready to cat}
 \item{content}{vector of lines comprising the ruler}
 \item{width}{width of ruler}
 \item{leftmargin}{position of the first tick relative to the left edge of the ruler}
}
}
\description{
'   \preformatted{
'   v borders
'   +-----------------------------------------------------------------+<-borders
'   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||<-dense_ticks
'   |  |    |    |    |    |    |    |    |    |    |    |    |    |  |<-sparse_ticks
'   |-30       -20       -10         0         10        20        30 |
'   +-----------------------------------------------------------------+<-borders
'   }
}
\examples{
asciiruler(low=-30,high=30,borders=TRUE)
}
\references{
Inspired by \url{http://codegolf.stackexchange.com/questions/4910/ascii-ruler-generation}
}
